/*******************************************************************************

Copyright (c) 2010, Perforce Software, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1.  Redistributions of source code must retain the above copyright
	notice, this list of conditions and the following disclaimer.

2.  Redistributions in binary form must reproduce the above copyright
	notice, this list of conditions and the following disclaimer in the
	documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL PERFORCE SOFTWARE, INC. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/*******************************************************************************
 * Name		: p4bridge-api.h
 *
 * Author	: dbb
 *
 * Description	: A "Flat C" interface for the Perforce API. Used to provide 
 * 		  simple access for C#.NET using P/Invoke and dllimport.
 *
 ******************************************************************************/

class P4BridgeServer;
class P4ClientError;
class StrDictListIterator;
class StrDictList;
class KeyValuePair;
class P4ClientResolve;
class P4ClientMerge;
class P4ClientInfoMsg;
class Error;

typedef int _stdcall LogCallbackFn(int, const char*, int, const char*);

typedef void __stdcall BinaryCallbackFn( int, void *, int );
typedef void __stdcall TextCallbackFn(int, const char*);
typedef void __stdcall IntIntIntTextCallbackFn(int, int, int, const char*);
typedef void __stdcall IntIntTextCallbackFn(int, int, const char*);
//typedef void __stdcall TextTextCallbackFn(const char*, const char*);
typedef void __stdcall IntTextTextCallbackFn(int, int, const char*, const char*);

typedef void _stdcall PromptCallbackFn( int, const char *, char *, int, int);

typedef int _stdcall ResolveCallbackFn( int, P4ClientMerge *);
typedef int _stdcall ResolveACallbackFn( int, P4ClientResolve *, int preview);


enum MergeForce2 {
	CMF_AUTO2,	// don't force			// -am
	CMF_SAFE2,	// accept only non-conflicts	// -as
	CMF_FORCE2	// accept anything		// -af
} ;

class ClientInfoMsg
{
public:
	char Level;
	int	MsgCode;
	char * Message;
};


extern "C" 
{
	P4BridgeServer* Connect( char *server, 
							const char *user, 
							const char *pass,
							const char *ws_client,
							LogCallbackFn *log_fn);
	P4BridgeServer* TrustedConnect( char *server, 
															const char *user, 
															const char *pass,
															const char *ws_client,
															char *trust_flag,
															char *fingerprint,
															LogCallbackFn *log_fn);
	P4ClientError * GetConnectionError( void );
	int CloseConnection( P4BridgeServer* pServer );
	int Disconnect( P4BridgeServer* pServer );
	int IsUnicode( P4BridgeServer* pServer );
	int APILevel( P4BridgeServer* pServer );
	int UseLogin( P4BridgeServer* pServer );
	int SupportsExtSubmit( P4BridgeServer* pServer );
	char * SetCharacterSet(   P4BridgeServer* pServer, 
													const char * pCharSet, 
													const char * pFileCharSet );
	void set_connection( P4BridgeServer* pServer, 
									const char* newPort, 
									const char* newUser, 
									const char* newPassword, 
									const char* newClient );
	void set_client( P4BridgeServer* pServer, const char* workspace );
	const char * get_client( P4BridgeServer* pServer );
	char * get_user( P4BridgeServer* pServer );
	void set_user( P4BridgeServer* pServer, char * newValue );
	char * get_port( P4BridgeServer* pServer );
	void set_port( P4BridgeServer* pServer, char * newValue );
	char * get_password( P4BridgeServer* pServer );
	void set_password( P4BridgeServer* pServer, char * newValue );
	char * get_cwd( P4BridgeServer* pServer );
	void set_cwd( P4BridgeServer* pServer, 
									   const char * new_val );
	const char * get_programName( P4BridgeServer* pServer );
	void set_programName( P4BridgeServer* pServer, char * newValue );
	const char * get_programVer( P4BridgeServer* pServer );
	void set_programVer( P4BridgeServer* pServer, char * newValue );
	const char * get_charset( P4BridgeServer* pServer );
	char * get_config( P4BridgeServer* pServer );
	char* Get( P4BridgeServer* pServer, const char *var );
	void Set( P4BridgeServer* pServer, const char *var, const char *val );
	int RunCommand( P4BridgeServer* pServer, 
										  const char *cmd, 
										  int cmdId,
										  int tagged, 
										  char **args, 
										  int argc );
	void CancelCommand( P4BridgeServer* pServer, int cmdId ) ;
	void ReleaseConnection(P4BridgeServer* pServer, int cmdId, unsigned _int64 releaseTime);
	void FreeConnection(P4BridgeServer* pServer,unsigned _int64 currentTime);
	void SetTaggedOutputCallbackFn( P4BridgeServer* pServer, IntTextTextCallbackFn* pNew );
	StrDictListIterator * GetTaggedOutput( P4BridgeServer* pServer, int cmdId );
	void SetErrorCallbackFn( P4BridgeServer* pServer, IntIntIntTextCallbackFn* pNew );
	P4ClientError * GetErrorResults( P4BridgeServer * pServer, int cmdId);
	void SetInfoResultsCallbackFn( P4BridgeServer* pServer, IntIntTextCallbackFn* pNew );
	ClientInfoMsg * GetInfoResults( P4BridgeServer* pServer, int cmdId);
	void SetTextResultsCallbackFn( P4BridgeServer* pServer, TextCallbackFn* pNew );
	char * GetTextResults( P4BridgeServer* pServer, int cmdId );
	void SetBinaryResultsCallbackFn( P4BridgeServer* pServer, BinaryCallbackFn* pNew );
	int GetBinaryResultsCount(  P4BridgeServer* pServer, int cmdId) ;
	void *GetBinaryResults( P4BridgeServer* pServer, int cmdId );
	void SetDataSet( P4BridgeServer* pServer, int cmdId,
										   const char * data );
	 char * GetDataSet( P4BridgeServer* pServer, int cmdId );
	void SetPromptCallbackFn( P4BridgeServer* pServer, 
													PromptCallbackFn* pNew );
	StrDictList* GetNextItem( StrDictListIterator* pObj );
	KeyValuePair * GetNextEntry( StrDictListIterator* pObj );
	void Release( StrDictListIterator* pObj );
	const char * GetKey( KeyValuePair* pObj );
	const char *  GetValue( KeyValuePair* pObj );
	const int Severity( P4ClientError* pObj );
	const int ErrorCode( P4ClientError* pObj );
	const char * Message( P4ClientError* pObj );
	P4ClientError * Next( P4ClientError * pObj );
	int CM_AutoResolve( P4ClientMerge* pObj, MergeForce2 forceMerge );
	int CM_Resolve( P4ClientMerge* pObj );
	int CM_DetectResolve( P4ClientMerge* pObj );
	int CM_IsAcceptable( P4ClientMerge* pObj );
	char *CM_GetBaseFile( P4ClientMerge* pObj );
	char *CM_GetYourFile( P4ClientMerge* pObj );
	char *CM_GetTheirFile( P4ClientMerge* pObj );
	char *CM_GetResultFile( P4ClientMerge* pObj );
	int	CM_GetYourChunks( P4ClientMerge* pObj );
	int	CM_GetTheirChunks( P4ClientMerge* pObj );
	int	CM_GetBothChunks( P4ClientMerge* pObj );
	int	CM_GetConflictChunks( P4ClientMerge* pObj );
	char *CM_GetMergeDigest( P4ClientMerge* pObj );
	char *CM_GetYourDigest( P4ClientMerge* pObj );
	char *CM_GetTheirDigest( P4ClientMerge* pObj );
	P4ClientError *CM_GetLastClientMergeError(P4ClientMerge* pObj);
	int CR_AutoResolve( P4ClientResolve* pObj, MergeForce2 force );
	int CR_Resolve( P4ClientResolve* pObj, int preview, Error *e );
	char *CR_GetType(P4ClientResolve* pObj);
	char *CR_GetMergeAction(P4ClientResolve* pObj);
	char *CR_GetYoursAction(P4ClientResolve* pObj);
	char *CR_GetTheirAction(P4ClientResolve* pObj);
	char *CR_GetMergePrompt(P4ClientResolve* pObj);
	char *CR_GetYoursPrompt(P4ClientResolve* pObj);
	char *CR_GetTheirPrompt(P4ClientResolve* pObj);
	char *CR_GetMergeOpt(P4ClientResolve* pObj);
	char *CR_GetYoursOpt(P4ClientResolve* pObj);
	char *CR_GetTheirOpt(P4ClientResolve* pObj);
	char *CR_GetSkipOpt(P4ClientResolve* pObj); 
	char *CR_GetHelpOpt(P4ClientResolve* pObj);
	char *CR_GetAutoOpt(P4ClientResolve* pObj);
	char *CR_GetPrompt(P4ClientResolve* pObj);
	char *CR_GetTypePrompt(P4ClientResolve* pObj);
	char *CR_GetUsageError(P4ClientResolve* pObj);
	char *CR_GetHelp(P4ClientResolve* pObj);
	P4ClientError *CR_GetLastError(P4ClientResolve* pObj);
	void SetResolveCallbackFn(	P4BridgeServer* pServer, 
														ResolveCallbackFn* pNew );
	void SetResolveACallbackFn(	P4BridgeServer* pServer, 
														ResolveACallbackFn* pNew );
}
